library(Hmisc)
library(foreign)
library(Synth)

# get data
# this may take up to 10 minutes, depending on your internet speed
data<-read.dta(file="http://www.qogdata.pol.gu.se/data/qog_std_ts_20dec13.dta")

# select 1980-2010 window
data<-subset(data, data$year<2011 & data$year>=1980)

# tag missing data
data$avgpop <- ave(data$wdi_pop, data$ccode, FUN=mean)
data$avggro <- ave(data$wdi_gdpgr, data$ccode, FUN=mean)
data$avggdp <- ave(data$wdi_gdp, data$ccode, FUN=mean)
data$avgopen <- ave(data$wdi_ttr, data$ccode, FUN=mean)
data$avginv <-ave(data$pwt_isg, data$ccode, FUN=mean)
data$avgpol <-ave(data$p_polity2, data$ccode, FUN=mean)
data$lngdp <- log(data$wdi_gdp)

# drop missing data countries to make balanced panel
data.torun<-data[,c("ccode","cname","year","wdi_gdpgr","wdi_ttr","wdi_pop","wdi_gdp","pwt_isg",
	"avgpop","avgopen","avggdp","avggro","lngdp","avginv","avgpol","p_polity2")]
data.torun<- data.torun[!is.na(data.torun$avgopen),]
data.torun<- data.torun[!is.na(data.torun$avggdp),]
data.torun<- data.torun[!is.na(data.torun$avgpop),]
data.torun<- data.torun[!is.na(data.torun$avggro),]
data.torun<- data.torun[!is.na(data.torun$avginv),]
data.torun<- data.torun[!is.na(data.torun$avgpol),]


# pick out donor pool
countries<-as.numeric(levels(as.factor(data.torun$ccode)))
controls<-subset(countries, countries %nin% 764)


# prep
dataprep.out<-
  dataprep(
   foo = data.torun,
   predictors = c("wdi_pop", "wdi_ttr","lngdp","pwt_isg","p_polity2"),
   dependent = "wdi_gdpgr",
   unit.variable = "ccode",
   time.variable = "year",
   predictors.op = "mean",
	special.predictors = list(
      list("wdi_gdpgr", 1998, "mean"),
      list("wdi_gdpgr", 1996, "mean"),
      list("wdi_gdpgr", 1990, "mean"),
      list("wdi_gdpgr", 1980, "mean")
                           ),
   treatment.identifier = 764,
   controls.identifier = controls,
   time.predictors.prior = c(1980:2000),
   time.optimize.ssr = c(1980:2001),
   unit.names.variable = "cname",
   time.plot = 1980:2010
   )

# analyze
synth.out <- synth(dataprep.out)

# output
synth.tables <- synth.tab(
      dataprep.res = dataprep.out,
      synth.res = synth.out)
print(synth.tables)

# plot
path.plot(dataprep.res = dataprep.out,synth.res = synth.out,
	Ylim=c(-15,15), Ylab="GDP Growth", Xlab="Year", 
	Legend.position="bottomleft", Legend=c("Thailand","Synthetic Thailand"))
abline(v=2001, col="red")
abline(v=2006, col="red")
